﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.Deducciones;
using System.Transactions;
using EntityFramework.BulkInsert.Extensions;


namespace Nova.Models.Calculos
{
    public class NominaConfianza : Nomina
    {
        private Nomina_stNominaTrabajador NominaTrabajador;

        private bdNovaEntities bd = new bdNovaEntities();
        //{
        public NominaConfianza(Nomina_stNominaTrabajador Nt)
        {
            NominaTrabajador = Nt;
        }

        public override void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            //SUELDO 
            Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
            sueldo.Calcular(cltc, this.NominaTrabajador);
            //QUINQUENIO
            QuinquenioConfianza quinquenio = new QuinquenioConfianza();
            quinquenio.Calcular(cltc, this.NominaTrabajador);

            //Prima vacacional
            PrimaVacacional primavacacional = new PrimaVacacional();
            primavacacional.Calcular(cltc, this.NominaTrabajador);

           
            //EFICIENCIA EN EL TRABAJO

            EficienciaTrabajConfianza eficienciaTrabajo = new EficienciaTrabajConfianza();
            eficienciaTrabajo.Calcular(cltc, this.NominaTrabajador);

           

            // AYUDA PARA DESPENSA
            Nova.Models.Calculos.Percepciones.AyudaDespensa ayudadespensa = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
            ayudadespensa.Calcular(cltc, this.NominaTrabajador);

            //VALES DE DESPENSA
            Nova.Models.Calculos.Percepciones.ValesDespensa valesdespensa = new Nova.Models.Calculos.Percepciones.ValesDespensa();
            valesdespensa.Calcular(cltc, this.NominaTrabajador);

            //PERCEPCIONES PERSONALIZADAS (GASTO ADMINISTRATIVO || NÓMINA RDL)
            Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
            percepcionpersonalizada.Calcular(cltc, this.NominaTrabajador);
            // Aguinaldo
            Nova.Models.Calculos.Percepciones.Aguinaldo aguinaldo = new Nova.Models.Calculos.Percepciones.Aguinaldo();
            aguinaldo.Calcular(cltc, this.NominaTrabajador);



        }

        public override void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.FaltasConfianza faltas = new Nova.Models.Calculos.Deducciones.FaltasConfianza();
            faltas.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.IMSS imss = new Nova.Models.Calculos.Deducciones.IMSS();
            imss.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.EnfermedadGeneral enfermedadgeneral = new Nova.Models.Calculos.Deducciones.EnfermedadGeneral();
            enfermedadgeneral.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.RiesgoTrabajo RiesgoTrabajo = new Nova.Models.Calculos.Deducciones.RiesgoTrabajo();
            RiesgoTrabajo.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.Maternidad Maternidad = new Nova.Models.Calculos.Deducciones.Maternidad();
            Maternidad.Calcular(cltc, this.NominaTrabajador);



        }
        public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
            cre.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
            cre.Calcular(cltc, this.NominaTrabajador);


        }


        public override void CalcularNomina()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }

            foreach (var Trabajador in this.NominaTrabajador.TrabajadoresVigentes)
            {
                //try
                //{
 
              
                NominaTrabajador.DiasPagados = NominaTrabajador.DiasNomina;

                    short IdConvenioLaboralTrabajador = Trabajador.IdConvenioLaboralTrabajador;

                    int IdConvenioLaboralTrabajadorCategoria = Trabajador.IdConvenioLaboralTrabajadorCategoria;
                    int IdTrabajador = Trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    // jc HttpContext.Current.Session["IdTrabajador"] = IdTrabajador;

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == Trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
         
                    //short IdJornadaLaboral = costos.IdJornadaLaboral;
                    //short IdCostoHoraJornada = costos.IdCostoHoraJornada;



                    /////////////////////////////////////////////////

                    //this.setConvenioLaboralTrabajador(IdTrabajador);
                  //  this.NominaTrabajador.setCostoHoraJornada(IdCostoHoraJornada);
                    this.NominaTrabajador.setIncidenciaTrabajador(IdConvenioLaboralTrabajador);

                 //   this.NominaTrabajador.DiasEfectivosLaborados = this.NominaTrabajador.ObtenDiasIncidenciasTrabajador();

                   // this.NominaTrabajador.setJornadaLaboral(IdJornadaLaboral);

                    //this.setNominaTrabajadorPercepciones(IdTrabajador);
                    this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                    //this.setCatalogoKardexTrabajadorCuentas(IdTrabajador);
                    //this.setTrabajador(IdConvenioLaboralTrabajadorCategoria);
                    this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajador);


                //}
                //catch (Exception e)
                //{
                //    throw new InvalidProgramException(e.Message);

                //}

                   // this.GenerarIncidenciasPermisos(Trabajador);
                    if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
                    {

                        NominaTrabajador.GenerarRetroactivo(Trabajador);



                    }
                    else
                    {
                        GenerarPermisos(Trabajador);
                        this.GenerarPercepciones(Trabajador);
                        this.GenerarDeducciones(Trabajador);
                    this.GenerarPensiones(Trabajador);
                    this.GenerarCreditos(Trabajador);
                       
                    }
                //  Console.WriteLine("--- fin --- " + DateTime.Now + " ** ");
            }

            GrabarStNominaTrabajador();
        }

      

        public override void GenerarPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.RiesgoTrabajo incapacidad = new Nova.Models.Calculos.Deducciones.RiesgoTrabajo();
            incapacidad.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.Maternidad maternidad = new Nova.Models.Calculos.Deducciones.Maternidad();
            maternidad.Calcular(cltc, this.NominaTrabajador);


        }
        //public override void GenerarIncidenciasPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{
        //    FaltasConfianza falta = new FaltasConfianza();
        //    falta.Calcular(cltc, this.NominaTrabajador);
        //}

        public override void GrabarStNominaTrabajador()
        {
            NominaTrabajador.CreditosDelTrabajador = new List<Creditos_stNominaCreditoTrabajador>();
            NominaTrabajador.PercepcionesDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
            NominaTrabajador.DeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
            NominaTrabajador.SubDeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();
            NominaTrabajador.PensionesDelTrabajador = new List<Pensiones_stNominaPensionTrabajador>();

            int y = 0;

            foreach (var item in NominaTrabajador.TrabajadoresVigentes)
            {
                y++;

                NominaTrabajador.trabajadornomina = null;
                NominaTrabajador.trabajadornomina = new Nomina_stNominaTrabajador();
                NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                NominaTrabajador.trabajadornomina.IdNomina = NominaTrabajador.IdNomina;
                NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);


                NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                
                decimal deducciones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && !NominaTrabajador.getDeduccionesExcluidas().Contains(i.IdPlantillaNominaDeduccion)).Sum(f => f.Importe), 2);

                decimal percepciones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                    
                    , creditos = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                    , pensiones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2);
                NominaTrabajador.trabajadornomina.SueldoNeto = percepciones - deducciones - creditos - pensiones;

                

                if (percepciones == 0)
                    throw new ApplicationException("Esta nomina ha generado valores en 0, revise su información puede ser que la nomina para esta quincena no sea aplicable");


                if (NominaTrabajador.trabajadornomina.SueldoNeto<0 )
                    NominaTrabajador.trabajadornomina.SueldoNeto = percepciones - deducciones -  pensiones;

                if (NominaTrabajador.trabajadornomina.SueldoNeto < 0 && NominaTrabajador.trabajadornomina.DiasPagados > 0)
                    throw   new ApplicationException ("El siguiente trabajador tiene fondos insuficientes "+item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre+" "+item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno+" " +item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno);

                //NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)

                //    - NominaTrabajador.ListaDeduccionesTrabajadores.Where(i=> i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                //    - NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                //    - NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                NominaTrabajador.trabajadornomina.SueldoNeto = decimal.Round(NominaTrabajador.Truncate(NominaTrabajador.trabajadornomina.SueldoNeto, 4), 2);

                if (NominaTrabajador.trabajadornomina.SueldoNeto < 0)
                {
                    NominaTrabajador.trabajadornomina.SueldoNeto = 0;
                    NominaTrabajador.trabajadornomina.SueldoDiario = 0;
                }


                NominaTrabajador.trabajadornomina.SueldoTransferencia = 0;
                NominaTrabajador.trabajadornomina.SueldoMonedero = 0;
                List<Kardex_stTrabajadorCuentas> cta = NominaTrabajador.CatalogoKardexTrabajadoresCuentas.Where(w => w.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && w.EsVigente && (w.Catalogos_ctFormaDePago.FormaDePago == "TRANSFERENCIA ELECTRÓNICA" || w.Catalogos_ctFormaDePago.FormaDePago == "EFECTIVO")).ToList();
                //if (cta.Count > 0)
                //{
                //    var cayuda = NominaTrabajador.PlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                //    decimal vales = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);

                //    NominaTrabajador.trabajadornomina.SueldoTransferencia = NominaTrabajador.trabajadornomina.SueldoNeto - vales;
                //    NominaTrabajador.trabajadornomina.IdTrabajadorCuentasTransferencia = cta.FirstOrDefault().IdTrabajadorCuentas;

                //}
                //else
                //{
                //    throw new InvalidProgramException("El trabajador " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " con Id: " + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " no tiene cuenta para transferencia electrónica o efectivo");
                //}

                //List<Kardex_stTrabajadorCuentas> ctamonedero = NominaTrabajador.CatalogoKardexTrabajadoresCuentas.Where(w => w.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && w.Catalogos_ctFormaDePago.FormaDePago == "MONEDERO ELECTRÓNICO").OrderByDescending(c => c.IdTrabajadorCuentas).ToList();
                //if (ctamonedero.Count > 0)
                //{
                    

                //    var  cayuda = NominaTrabajador.PlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                //    NominaTrabajador.trabajadornomina.SueldoMonedero = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);
                //    NominaTrabajador.trabajadornomina.IdTrabajadorCuentasMonedero = ctamonedero.FirstOrDefault().IdTrabajadorCuentas;
                //}
                //else
                //{
                //    throw new InvalidProgramException("El trabajador " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " con Id: " + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " no tiene cuenta para transferencia electrónica o efectivo");

                //}
                NominaTrabajador.trabajadornomina.HorasSemanaMes = 0;
                NominaTrabajador.trabajadornomina.HorasSemanaMesTrabajadas = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasExcedentes = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasInterinas = 0;
                decimal diasefectivos=NominaTrabajador.ListaVariablesNominaTrabajador.Where(F=> F.IdConvenioLaboralTrabajadorCategoria==item.IdConvenioLaboralTrabajadorCategoria && F.Concepto=="FALTAS").Sum(e=> e.Importe);
                if (diasefectivos==0)
                    NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasNomina ;
                else
                {
                    //short dl=System.Convert.ToInt16(diasefectivos.Importe);
                    
                    //NominaTrabajador.trabajadornomina.DiasEfectivosLaborados =(short)dl ;
                    NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = (short)(NominaTrabajador.DiasNomina - diasefectivos);
                }
                


                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                if (costos != null)
                {
                    NominaTrabajador.trabajadornomina.CostoPorHora = costos.CostoPorHora;
                    
                    NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.trabajadornomina.DiasEfectivosLaborados * costos.Catalogos_ctJornadaLaboral.HorasMaximo);
                }
                NominaTrabajador.trabajadornomina.CostoPorHoraExcedente = 0;
                NominaTrabajador.trabajadornomina.CostoPorHorasInterinas = 0;


                



                NominaTrabajador.trabajadornomina.SalarioDiarioIntegrado = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SALARIO DIARIO INTEGRADO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                NominaTrabajador.trabajadornomina.QuinquenioDiario = 0;
                NominaTrabajador.trabajadornomina.MaterialDidacticoDiario = 0;

                var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                if (idquinqueniopercepcion != null)
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = NominaTrabajador.trabajadornomina.SueldoBruto + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion == g.IdPlantillaNominaPercepcion).Sum(r => r.Importe);
                else
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = NominaTrabajador.trabajadornomina.SueldoBruto;

                NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe) - NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).Sum(f => f.Importe);
                NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
              
                //NominaTrabajador.trabajadornomina.EsDevolucion = false;
                NominaTrabajador.trabajadornomina.SalarioBrutoGravable = NominaTrabajador.ListaNominaPercepcionesTrabajador.Where(z => z.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.EsGravable == true).Sum(x => x.Importe);
                NominaTrabajador.Nomina_stNominaTrabajadorLista.Add(NominaTrabajador.trabajadornomina);


 

            }

            NominaTrabajador.GrabarNominaBaseDatos();

        }

 

    }
}
